'use strict'
document.addEventListener("DOMContentLoaded", function () {

    const iawDefault = {
        merchant: 'WIDGET', // Пример мерчанта для ифт
        btnId: 'buy-button',       // Пример идентификатора для кнопок
    };

    /**
     * ПРАВКИ DEV/IFT/TEST - ИСПРАВИТЬ ПЕРЕД ПРОДОМ!!!
     *
     * this.iawUrl - переключение dev/ift
     * let fUrl - подставляется ссылка на реальный тестовый заказ
     * #setStyle() - использует относительный путь
     * sendRequest() - есть заглушка для заголовка
     */

    class vtbIAW {

        /**
         * vtbIAW constructor class
         * @param options
         */
        constructor(options) {
            this.iawClose = document.createElement('div');
            this.frameWrapper = document.createElement('div')
            this.iawCloseBtnWrapper = document.createElement('div');
            this.iawCloseBtn = document.createElement('button');
            this.iawFrame = document.createElement('iframe');
            this.iawStyle = document.createElement('link');
            this.iawBtn = options.btnId;
            this.iawUrl = 'https://pay.vtb.ru/api/tsp-ia-box-cloud-cms/v1/orders';
            this.iawMerchant = options.merchant;

            if (this.iawMerchant.length <= 0) {
                throw new Error('[IAW] Credential: Merchant lost');
            }

            if (this.iawBtn.length <= 0) {
                throw new Error('[IAW] Button ID cannot be empty');
            }

            this.#init();
        }

        /**
         * getAttribute - from target
         * @param target
         * @returns {{}}
         */
        #getAttr(target) {
            return { price: target.attributes['data-price'].value, id: this.#getUid() }
        }

        #generateRandomCode() {
            let code = "";
            for (let i = 0; i < 4; i++) {
                const randomDigit = Math.floor(Math.random() * 10); // от 0 до 9
                code += randomDigit;
            }
            return code;
        }

        #getUid() {
            const date = new Date();
            const year = date.getFullYear();
            const month = String(date.getMonth() + 1).padStart(2, '0');
            const day = String(date.getDate()).padStart(2, '0');
            const hour = String(date.getHours()).padStart(2, '0');
            const minute = String(date.getMinutes()).padStart(2, '0');
            const second = String(date.getSeconds()).padStart(2, '0');
            const millisecond = String(date.getMilliseconds()).padStart(3, '0');

            return `WT${this.#generateRandomCode()}${year}${month}${day}${hour}${minute}${second}${millisecond}${this.#generateRandomCode()}`;
        }

        /**
         * setStyle - include style for widget ui
         */
        #setStyle() {
            this.iawStyle.setAttribute("href", "./public/css/iaw.css");
            this.iawStyle.setAttribute("rel", "stylesheet");
            document.head.appendChild(this.iawStyle);
        }

        /**
         * setFrame - make iframe with target url
         * @param url
         */
        #setFrame(url) {
            try {
                if (url.length > 0) {
                    let attrs = {
                        src: url,
                        class: 'iawFrame',
                        allowpaymentrequest: 'true',
                        allowtransparency: 'true',
                        frameborder: '0',
                        loading: 'lazy'
                    };

                    Object.entries(attrs).forEach(([attr, value]) =>
                        this.iawFrame.setAttribute(attr, value),
                    );
                    this.frameWrapper.className = 'frameWrapper'
                    this.#setClose()
                    this.frameWrapper.appendChild(this.iawFrame)
                    this.iawClose.appendChild(this.frameWrapper);
                    this.iawClose.setAttribute('class', 'iawShow');
                }
            } catch (error) {
                throw new Error(`[IAW] Frame link cannot be null or Frame cannot be load target page: ${error}`);
            }
        }

        /**
         * setClose - make iframe background container
         */
        #setClose() {
            this.iawCloseBtn.setAttribute('type', 'button');
            this.iawCloseBtn.setAttribute('class', 'iawCloseButton');
            this.iawCloseBtnWrapper.setAttribute('class', 'iawCloseBtnWrapper');
            this.iawCloseBtnWrapper.appendChild(this.iawCloseBtn);
            this.frameWrapper.appendChild(this.iawCloseBtnWrapper);
            document.body.appendChild(this.iawClose);
        }

        /**
         * setListener - make a global listeners
         */
        #setListener() {
            let button = document.querySelectorAll(`#${this.iawBtn}`);
            let _this = this;

            _this.iawCloseBtnWrapper.addEventListener('click', function (e) {
                e.preventDefault();
                e.stopPropagation();
                _this.iawClose.remove();
            });

            if (button.length > 0) {
                button.forEach(function (el) {
                    el.addEventListener('click', async function (e) {
                        e.preventDefault();
                        e.stopPropagation();

                        let payData;

                        payData = _this.#getAttr(e.target);
                        await _this.#sendAction('order', payData);
                    });
                });
            }
        }

        /**
         * setAction - main controller
         * @param action
         * @param options
         * @returns {Promise<*>}
         */
        async #sendAction(action, options) {
            let _this = this, result, timestamp = new Date(), args, price;

            if (options.price) {
                price = options.price.replace(',','.'); // just a JavaScript prank
            }

            timestamp.setDate(timestamp.getDate() + 1);
            timestamp = timestamp.toISOString();

            args = {
                'orderId': options.id,
                'orderName': `№ ${options.id}`,
                'expire': timestamp,
                'amount': {
                    'value': parseFloat(price),
                    'code': 'RUB'
                }
            }

            _this.#sendRequest(
                'post',
                _this.iawUrl,
                args
            ).then(data => {
                try {
                    if (data) {
                        _this.#setFrame(data.object.payUrl);
                        // _this.#setFrame('http://127.0.0.1:9000/?order-id=TESTORDERID&isWidget=true');
                    }
                } catch (error) {
                    throw new Error(`[IAW] Order do not created: ${error}`);
                }
            }).catch(error => {
                throw new Error(`[IAW] Request failed: ${error}`);
            });
        }

        /**
         * sendRequest - make fetch requests
         * @param method
         * @param url
         * @param body
         * @returns {Promise<any>}
         */
        async #sendRequest(method, url, body = null) {
            let data = JSON.stringify(body);
            let _this = this,
                result,
                options = {
                    method: method.toUpperCase(),
                    headers: {
                        'Content-Type': 'application/json',
                        'Content-Length': data.length ? data.length : 0,
                        // 'Merchant-Host': location.origin, // для прода
                        'Merchant-Host': '', // хост для ифт
                        'Merchant-Authorization': _this.iawMerchant,
                    },
                    redirect: 'follow',
                };

            if (body !== null) {
                options.body = data;
            }

            result = await fetch(url, options);
            return result.json();
        }

        /**
         * init - initialize class
         */
        #init() {
            this.#setStyle();
            this.#setListener();
        }
    }

    new vtbIAW((typeof iawOptions !== 'undefined') ? iawOptions : iawDefault);
});
